/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.instances;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityRoad;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.systems.ConfigSystem;

public class BlockCollision
extends ABlockBase {
    public static List<BlockCollision> blockInstances = BlockCollision.createCollisionBlocks();
    public final BoundingBox blockBounds;

    public BlockCollision(int collisionHeightInPixels) {
        super(1.5f, 6.0f);
        if (collisionHeightInPixels == 0) {
            collisionHeightInPixels = 1;
        }
        float heightRadiusRequired = (float)collisionHeightInPixels / 16.0f / 2.0f;
        this.blockBounds = new BoundingBox(new Point3D(0.5, heightRadiusRequired, 0.5), 0.5, heightRadiusRequired, 0.5);
    }

    @Override
    public void onBroken(AWrapperWorld world, Point3D position) {
        TileEntityRoad masterBlock = this.getMasterRoad(world, position);
        if (masterBlock != null && masterBlock.isActive()) {
            world.destroyBlock(masterBlock.position, true);
        }
    }

    public TileEntityRoad getMasterRoad(AWrapperWorld world, Point3D position) {
        Point3D blockOffset = new Point3D();
        Point3D testPoint = new Point3D();
        for (int j = -((Integer)ConfigSystem.settings.general.roadMaxLength.value).intValue(); j < 2 * (Integer)ConfigSystem.settings.general.roadMaxLength.value; ++j) {
            for (int i = -((Integer)ConfigSystem.settings.general.roadMaxLength.value).intValue(); i < 2 * (Integer)ConfigSystem.settings.general.roadMaxLength.value; ++i) {
                for (int k = -((Integer)ConfigSystem.settings.general.roadMaxLength.value).intValue(); k < 2 * (Integer)ConfigSystem.settings.general.roadMaxLength.value; ++k) {
                    blockOffset.set(i, j, k);
                    testPoint.set(position);
                    testPoint.subtract(blockOffset);
                    Object testTile = world.getTileEntity(testPoint);
                    if (!(testTile instanceof TileEntityRoad) || !((TileEntityRoad)testTile).collisionBlockOffsets.contains(blockOffset)) continue;
                    return (TileEntityRoad)testTile;
                }
            }
        }
        return null;
    }

    private static List<BlockCollision> createCollisionBlocks() {
        ArrayList<BlockCollision> blocks = new ArrayList<BlockCollision>();
        for (int i = 0; i < 16; ++i) {
            blocks.add(new BlockCollision(i));
        }
        return blocks;
    }
}

